package cn.com.duiba.kjy.api.enums.seller;

/**
 * @author zhanghuifeng
 * date 2020/9/25-17:18
 */
public enum RemarkStateEnum {

    YES(1, "已备注"),
    NO(0, "未备注"),
    ;
    private Integer code;

    private String desc;

    RemarkStateEnum(Integer code, String desc){
        this.code = code;
        this.desc = desc;
    }

    /**
     * x
     * @param code
     * @return
     */
    public static RemarkStateEnum getByCode(Integer code) {
        for (RemarkStateEnum enumVal : RemarkStateEnum.values()) {
            if (enumVal.getCode().equals(code)) {
                return enumVal;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
