package cn.com.duiba.kjy.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.sellerCustomerInfoExt.SellerCustomerInfoExtDto;

import java.util.List;

/**
 * @author chentiecheng
 * @description  销售客户信息拓展服务
 * @date 2019-02-17 22:38
 */
@AdvancedFeignClient
public interface RemoteSellerCustomerInfoExtService {

    /**
     * 根据销售客户表id查询客户信息
     * @param customerId
     * @return
     */
    SellerCustomerInfoExtDto selectInfoByCustomerId(Long customerId);

    /**
     * 根据销售客户表id列表 查询客户信息
     * @param customerIds 销售客户表id列表
     * @return
     */
    List<SellerCustomerInfoExtDto> selectInfoListByCustomerIds(List<Long> customerIds);

    /**
     * 新增或更新客户拓展信息
     * @param sellerCustomerInfoExtDto
     * @return
     */
    Boolean saveOrUpdateInfo(SellerCustomerInfoExtDto sellerCustomerInfoExtDto);

}
