package cn.com.duiba.kjy.api.dto.vipTransfer;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 付费会员转移记录表
 * @author kjj mybatis generator 
 * 2020-04-26
 */
@Data
public class VipTransferDto implements Serializable {
    private static final long serialVersionUID = 15879003523975387L;

    /**
     *
     *主键
     * not null default = null
     */
    private Long id;

    /**
     *
     *转移前代理人id
     * not null default = null
     */
    private Long oldSellerId;

    /**
     *
     *转移后代理人id
     * not null default = null
     */
    private Long newSellerId;

    /**
     *
     *操作人id
     * not null default = null
     */
    private Long operatorId;

    /**
     *
     *操作人
     * max length = 32
     * not null default = null
     */
    private String operatorAccount;

    /**
     *
     *操作原因
     * max length = 200
     * not null default = null
     */
    private String opReason;

    /**
     *
     *创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     *
     *更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    /**
     *
     *用户版本
     */
    private Integer userVersion;

    /**
     *
     *公司Id
     */
    private Long companyId;

    /**
     *
     *迁移完之后会员的有效期
     */
    private Date vipEndTime;
}