package cn.com.duiba.kjy.api.util;

import cn.com.duiba.kjy.api.enums.renew.VipCycleEnum;
import lombok.extern.slf4j.Slf4j;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.Objects;

/**
 * @author: linjianhui
 * @date: 2020/10/27 15:22
 * @description: 会员剩余有效期所属区间
 */
@Slf4j
public class SellerVipCycleUtil {

    /**
     * 计算会员有效期所属阶段
     * @param now 系统当前时间
     * @param vipEndTime 会员过期时间
     * @return
     */
    public static VipCycleEnum calculateVipCycle(LocalDateTime now, Date vipEndTime) {
        if (Objects.isNull(now) || Objects.isNull(vipEndTime)){
            return null;
        }
        //会员有效期大于30天
        if (Date.from(now.plusDays(VipCycleEnum.CYCLE_THIRTY_FIFTEEN.getCode()).atZone(ZoneId.systemDefault()).toInstant()).before(vipEndTime)) {
            return null;
        }
        if (Date.from(now.plusDays(VipCycleEnum.CYCLE_FIFTEEN_TODAY.getCode()).atZone(ZoneId.systemDefault()).toInstant()).before(vipEndTime)) {
            return VipCycleEnum.CYCLE_THIRTY_FIFTEEN;
        }else if (Date.from(now.plusDays(VipCycleEnum.CYCLE_TODAY.getCode()).atZone(ZoneId.systemDefault()).toInstant()).before(vipEndTime)) {
            return VipCycleEnum.CYCLE_FIFTEEN_TODAY;
        }else if (Date.from(now.atZone(ZoneId.systemDefault()).toInstant()).before(vipEndTime)){
            return VipCycleEnum.CYCLE_TODAY;
        }else if (Date.from(now.plusDays(VipCycleEnum.EXPIRED_THREE_DAYS.getCode()).atZone(ZoneId.systemDefault()).toInstant()).before(vipEndTime)) {
            return VipCycleEnum.EXPIRED_THREE_DAYS;
        }else if (Date.from(now.plusDays(VipCycleEnum.EXPIRED_FIFTEEN_DAYS.getCode()).atZone(ZoneId.systemDefault()).toInstant()).before(vipEndTime)) {
            return VipCycleEnum.EXPIRED_FIFTEEN_DAYS;
        }
        return null;
    }
}
