package cn.com.duiba.kjy.api.remoteservice.pay;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.pay.WxDuiBaRefundRecordDto;
import cn.com.duiba.kjy.api.params.pay.WxDuiBaRefundRecordParam;

import java.util.List;

/**
 * 调用兑吧退款记录
 * @author lizhi
 * @date 2020/1/12 11:31 AM
 */
@AdvancedFeignClient
public interface RemoteWxDuiBaRefundRecordService {

    /**
     * 根据客集集订单号查询退款金额
     * @param bizOrderNo 客集集订单号
     * @return 退款金额，单位分
     */
    int findRefundAmountByBizOrderNo(String bizOrderNo);

    /**
     * 根据参数查询，不分页
     * @param param 参数
     * @return 退款相关信息
     */
    List<WxDuiBaRefundRecordDto> selectPage(WxDuiBaRefundRecordParam param);

    /**
     * 根据条件查询记录的总记录数
     * @param param 参数
     * @return 退款相关信息
     */
    long selectCount(WxDuiBaRefundRecordParam param);

    /**
     * 退款重试
     * @param bizOrderNo 业务订单号
     * @return 重试结果：true-成功，false-失败
     */
    boolean refundRetry(String bizOrderNo);
}
