package cn.com.duiba.kjy.api.remoteservice.seller;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * 销售关闭不展示的公司产品管理
 * @Author chentiecheng
 * @Date 2020/5/9 4:10 下午
 */
@AdvancedFeignClient
public interface RemoteSellerUnShownProductService {
    /**
     * 根据销售id获取该销售不展示的产品id列表
     * @param sellerId
     * @return
     */
    List<Long> selectUnShownProductIdList(Long sellerId);

    /**
     * 更新产品展示状态
     * @param sellerId
     * @param productId 产品id
     * @param isShow 展示状态，true展示，false不展示
     * @return
     */
    Boolean updateProductShowStatus(Long sellerId, Long productId, Boolean isShow);
    /**
     * 根据产品id删除记录
     * @param productId
     * @return
     */
    Boolean deleteByProductId(Long productId);
}
