package cn.com.duiba.kjy.api.remoteservice.timingLottery;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.timingLottery.TimingLotterySellerDto;

import java.util.List;

/**
 * Service
 *
 * @author xiaotian
 * 2021-1-6 10:10:50
 */
@AdvancedFeignClient
public interface RemoteTimingLotterySellerService {
    /**
     * 新增记录
     */
    Boolean save(TimingLotterySellerDto dto);

    /**
     * 批量新增记录
     */
    Boolean batchSave(List<TimingLotterySellerDto> dto);

    /**
     * 根据id删除
     */
    Boolean deleteById(Long id);

    /**
     * 根据id更新
     */
    Boolean updateById(TimingLotterySellerDto dto);

    /**
     * 根据id获取
     */
    TimingLotterySellerDto getById(Long id);

    /**
     * 获取用户的微信公众号文章
     *
     * @param sellerId
     * @return
     */
    List<TimingLotterySellerDto> getListBySellerId(Long sellerId);


}
