/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.api.enums.content;

import cn.com.duiba.kjy.api.util.IdMakerUtil;
import com.google.common.collect.ImmutableMap;
import org.apache.commons.lang.StringUtils;

public enum ContentPushReplyEnum {
    DAILY_CONTENT("ZB", "\u65e9\u62a5"),
    EVENING_GREETING("WX", "\u665a\u5b89\u5fc3\u8bed"),
    GRASS_CONTENT("ZC", "\u79cd\u8349\u7d20\u6750"),
    HOT_CONTENT("RW", "\u70ed\u6587");

    private final String replyPrefix;
    private final String desc;
    private static final ImmutableMap<String, ContentPushReplyEnum> map;

    public static ContentPushReplyEnum getEnumByReplyPrefix(String replyPrefix) {
        if (StringUtils.isBlank((String)replyPrefix)) {
            return null;
        }
        return (ContentPushReplyEnum)((Object)map.get((Object)replyPrefix));
    }

    public String getReplyLink(Long contentId, String msg, int index) {
        String replyMsg = StringUtils.join((Object[])new String[]{this.getReplyPrefix(), IdMakerUtil.encodingIdByBase64(contentId), String.valueOf(index)}, (String)"_");
        return "<a href='weixin://bizmsgmenu?msgmenucontent=" + replyMsg + "&msgmenuid=0'>" + msg + "</a>";
    }

    public String getReplyPrefix() {
        return this.replyPrefix;
    }

    public String getDesc() {
        return this.desc;
    }

    private ContentPushReplyEnum(String replyPrefix, String desc) {
        this.replyPrefix = replyPrefix;
        this.desc = desc;
    }

    static {
        map = ImmutableMap.builder().put((Object)ContentPushReplyEnum.DAILY_CONTENT.replyPrefix, (Object)DAILY_CONTENT).put((Object)ContentPushReplyEnum.EVENING_GREETING.replyPrefix, (Object)EVENING_GREETING).put((Object)ContentPushReplyEnum.GRASS_CONTENT.replyPrefix, (Object)GRASS_CONTENT).put((Object)ContentPushReplyEnum.HOT_CONTENT.replyPrefix, (Object)HOT_CONTENT).build();
    }
}

