package cn.com.duiba.kjy.api.enums.survey;

import lombok.AllArgsConstructor;
import lombok.Getter;
import org.apache.commons.lang.StringUtils;

/**
 * @author liuchao1
 */
@AllArgsConstructor
@Getter
public enum SurveyOptionTypeEnum {
    /**
     * 答题时，只保存选项Id
     */
    NORMAL("普通"),
    /**
     * 答题时，除了选项Id，还要保存文本
     */
    OTHER("其他"),
    ;


    private final String msg;

    public static SurveyOptionTypeEnum getByType(String type) {
        for (SurveyOptionTypeEnum value : SurveyOptionTypeEnum.values()) {
            if (StringUtils.equalsIgnoreCase(value.toString(), type)) {
                return value;
            }
        }
        // 识别不出，就当普通处理
        return SurveyOptionTypeEnum.NORMAL;
    }
}
