package cn.com.duiba.kjy.api.remoteservice.aivideo;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.aivideo.AiVideoPhotoFrameDto;

import java.util.List;

/**
 * ai跟拍视频相框remoteService
 *
 * @author ZhangJun
 * @create 2021/5/23 8:53 下午
 */
@AdvancedFeignClient
public interface RemoteAiVideoPhotoFrameService {

    /**
     * 批量添加相框
     *
     * @param photoFrameDtos 相框集合
     * @return 相框id
     */
    List<Long> addPhotoFrames(List<AiVideoPhotoFrameDto> photoFrameDtos);

    /**
     * 批量添加相框并与视频模版建立关联关系
     *
     * @param videoTemplateId 视频模版id
     * @param photoFrameDtos 相框dto
     * @return boolean
     */
    boolean addPhotoFramesAndRelations(Long videoTemplateId, List<AiVideoPhotoFrameDto> photoFrameDtos);

    /**
     * 批量删除相框
     *
     * @param photoFrameIds 相框id集合
     * @return 删除结果
     */
    boolean deletePhotoFrames(List<Long> photoFrameIds);

    /**
     * 批量删除相框并与指定视频模版解除关联关系
     *
     * @param videoTemplateId 视频模版id
     * @param photoFrameIds 相框id集合
     * @return boolean
     */
    boolean deletePhotoFramesAndRelations(Long videoTemplateId, List<Long> photoFrameIds);

    /**
     * 根据id批量查询相框
     *
     * @param photoFrameIds 相框id集合
     * @return 相框集合
     */
    List<AiVideoPhotoFrameDto> list(List<Long> photoFrameIds);

}
