package cn.com.duiba.kjy.api.remoteservice.clockin;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.clockin.SellerClockInProgressDto;
import cn.com.duiba.kjy.api.enums.clockin.ClockInTypeEnum;

/**
 * 打卡进度
 *
 * @author xuzhigang
 * @date 2021/4/14 9:45 上午
 **/
@AdvancedFeignClient
public interface RemoteSellerClockInProgressService {

    /**
     * 根据sellerId和打卡类型查询未结束的打卡进度
     *
     * @param sellerId 销售id
     * @param clockInType 打卡类型 {@link cn.com.duiba.kjy.api.enums.clockin.ClockInTypeEnum}
     * @return 打卡进度
     */
    SellerClockInProgressDto selectNotEndBySellerIdAndClockType(Long sellerId, Integer clockInType);

    /**
     * 根据代理人ID和打卡类型查询条数（未删除）
     * @param sellerId     代理人ID
     * @param clockInType 打卡类型 {@link ClockInTypeEnum}
     * @return 条数
     */
    int countBySellerIdAndClockType(Long sellerId, Integer clockInType);
}
