package cn.com.duiba.kjy.api.enums.billing;

import java.util.HashMap;
import java.util.Map;

/**
 * @author zhanghuifeng
 * date 2020/11/19-11:55
 */
public enum  BillingClockAwardConfTypeEnum {

    WEEK_AWARD(1, "周奖励"),
    BOOS_AWARD(2, "终极奖励"),

    ;

    private Integer code;
    private String desc;

    BillingClockAwardConfTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private static final Map<Integer, BillingClockAwardConfTypeEnum> ENUM_MAP = new HashMap<>();

    static{
        for(BillingClockAwardConfTypeEnum stateEnum : values()){
            ENUM_MAP.put(stateEnum.getCode(), stateEnum);
        }
    }

    public static BillingClockAwardConfTypeEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
