package cn.com.duiba.kjy.api.enums.crm.customer;

import java.util.HashMap;
import java.util.Map;

/**
 * @author linjianhui
 * @description 审核状态
 * @date 2020/12/18 11:17
 */
public enum CustomerVerifyStateEnum {

    /**
     * 确认合作，审核状态
     */
    VERIFY_WAIT(1, "审核中"),
    VERIFY_CANCEL(2, "已撤销"),
    VERIFY_PASS(3, "已通过"),
    VERIFY_REFUSE(4, "已拒绝"),
    ;

    private Integer code;
    private String desc;

    CustomerVerifyStateEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private static final Map<Integer, CustomerVerifyStateEnum> ENUM_MAP = new HashMap<>();

    static{
        for(CustomerVerifyStateEnum stateEnum : values()){
            ENUM_MAP.put(stateEnum.getCode(), stateEnum);
        }
    }

    public static CustomerVerifyStateEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
