package cn.com.duiba.kjy.api.enums.interaction;

import java.util.HashMap;
import java.util.Map;

/**
 * @author lizhi
 * @date 2019/9/19 2:46 PM
 */
public enum  InteractionOptionAnswerEnum {

    ANSWER((byte)0, "是答案"),
    NON_ANSWER((byte)1, "不是答案"),
    ;

    private Byte code;

    private String desc;

    InteractionOptionAnswerEnum(Byte code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Byte getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    private static final Map<Byte, InteractionOptionAnswerEnum> ENUM_MAP = new HashMap<>();

    static{
        for(InteractionOptionAnswerEnum answerEnum : values()){
            ENUM_MAP.put(answerEnum.getCode(), answerEnum);
        }
    }

    public static InteractionOptionAnswerEnum getByCode(Byte code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }
}
