package cn.com.duiba.kjy.api.params.survey;

import lombok.Data;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @author wutong
 */
@Data
public class AnswerApiParam implements Serializable {

    private static final long serialVersionUID = 5828077075706178685L;
    /**
     * ID
     */
    private Long id;

    /**
     * 问题Id
     */
    @NotNull
    @Min(value = 1, message = "questionId不合法")
    private Long questionId;

    private String questionType;

    /**
     * 用户选择的答案选项
     */
    @NotNull(message = "答案不允许为空")
    private List<AnswerContentApiParam> contentList;

}
