package cn.com.duiba.kjy.api.params;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author lizhi
 * @date 2019/11/11 12:21 PM
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class SellerPushSwitchParams extends PageQuery {

    private static final long serialVersionUID = -6608260319296010946L;

    /**
     * 销售员id，对应tb_seller.id
     */
    private Long sellerId;

    /**
     * 推送类型，1=早报、2=午后话题、3=晚安心语、4=热文、5=来访、6=每日统计、7=每周统计、8=收益统计
     * @see cn.com.duiba.kjy.api.enums.push.PushEnum
     */
    private Integer pushType;

    /**
     * 推送开关，0=关闭、1=开启
     * @see cn.com.duiba.kjy.api.enums.push.PushSwitchEnum
     */
    private Integer pushSwitch;
}
