package cn.com.duiba.kjy.api.remoteservice.presentInsurance;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.constant.KjyCenterException;
import cn.com.duiba.kjy.api.dto.preInstall.PreInstallBatchDto;
import cn.com.duiba.kjy.api.dto.preInstall.PreInstallSellerDto;
import cn.com.duiba.kjy.api.dto.presentInsurance.PresentInsuranceDto;
import cn.com.duiba.kjy.api.params.Page;
import cn.com.duiba.kjy.api.params.preInstall.ActivateParam;
import cn.com.duiba.kjy.api.params.preInstall.AddBatchParam;
import cn.com.duiba.kjy.api.params.preInstall.LivePageQuery;
import cn.com.duiba.kjy.api.params.preInstall.PreInstallPageQuery;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @auther: xiaotian
 * @date: 2020-04-13 14:17
 * @description: 预设会员remote接口
 */
@AdvancedFeignClient
public interface RemotePresentInsuranceService {

    /**
     * 新增
     * @param presentInsuranceDto
     * @return
     */
    boolean  add(PresentInsuranceDto presentInsuranceDto) throws KjyCenterException;

    /**
     * 删除
     * @param id
     * @return
     */
    boolean del(Long id);

    /**
     * 根据sellerId获取开启的赠险险种
     * @param sellerId
     * @return
     */
    List<PresentInsuranceDto> selectInUseBySellerId(Long sellerId);

    /**
     * 更新赠险
     * @param presentInsuranceDto
     * @return
     */
    boolean update(PresentInsuranceDto presentInsuranceDto) throws KjyCenterException;

    /**
     * 通过主键Id获取详情
     * @param id
     * @return
     */
    PresentInsuranceDto find(Long id);


    /**
     * 通过主键Id列表获取详情
     * @param ids
     * @return
     */
    List<PresentInsuranceDto> findByIdList(List<Long> ids);


    /**
     * 获取最后一条记录
     * @param sellerId
     * @param insuranceType
     * @return
     */
    PresentInsuranceDto findLast(Long sellerId,Integer insuranceType);


    /**
     * 增肌基础询问值
     * @param id
     * @return
     */
    boolean addBaseNum(Long id);
}
