/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.api.util;

public class BitUtils {
    public static long addBit(long number, int position) {
        if (number < 0L || position < 0) {
            return 0L;
        }
        return number | BitUtils.moveLeft1(position);
    }

    public static boolean isTrue(long number, int position) {
        if (number < 0L || position < 0) {
            return false;
        }
        long decimalValue = BitUtils.moveLeft1(position);
        return (decimalValue & number) == decimalValue;
    }

    public static long removeBit(long number, int position) {
        if (number < 0L || position < 0) {
            return 0L;
        }
        if (BitUtils.isTrue(number, position)) {
            number -= BitUtils.moveLeft1(position);
        }
        return number;
    }

    public static Integer valueOfBit(long number, int position) {
        if (number < 0L || position < 0) {
            return 0;
        }
        return Math.toIntExact(number >> ++position - 1 & 1L);
    }

    private static long moveLeft1(int num) {
        return 1L << num;
    }

    public static void main(String[] args) {
        long num = 11L;
        System.out.println(BitUtils.valueOfBit(num, 0));
        System.out.println(BitUtils.valueOfBit(num, 1));
        System.out.println(BitUtils.valueOfBit(num, 2));
        System.out.println(BitUtils.valueOfBit(num, 3));
        long num1 = 3L;
        long addBit = BitUtils.addBit(num1, 3);
        System.out.println(addBit);
        System.out.println(BitUtils.removeBit(addBit, 1));
    }
}

