package cn.com.duiba.kjy.api.enums.reward;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author wangbinbin
 * @create 2021-03-16 11:22
 * @descript 活动状态枚举
 */
@AllArgsConstructor
@Getter
public enum RewardActivityStatusEnum {

    /**
     * 活动进行中
     */
    IN_PROGRESS(1, "活动进行中"),

    /**
     * 活动已结束
     */
    END(2, "活动已结束"),
    ;

    /**
     * 代码
     */
    private final Integer code;

    /**
     * 代码描述
     */
    private final String description;
}
