/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.api.util;

import cn.com.duiba.kjy.api.constant.KjyRuntimeException;
import cn.com.duiba.kjy.api.util.NumberUtil;
import cn.com.duiba.kjy.api.util.SellerIdConverter;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;

public class ScIdConverter {
    public static Long encode(Long scId) {
        if (Objects.isNull(scId)) {
            throw new KjyRuntimeException("\u9500\u552eID\u4e3a\u7a7a,\u65e0\u6cd5\u83b7\u53d6\u4f1a\u5458ID");
        }
        if (scId > 999999999L) {
            throw new KjyRuntimeException("\u9500\u552eID\u6700\u5927\u652f\u6301999999999");
        }
        String scIdStr = String.valueOf(scId);
        int length = scIdStr.length();
        int replaceLength = 9 - length;
        String replaceStr = SellerIdConverter.getReplaceStr(replaceLength, scIdStr);
        return Long.valueOf(length + replaceStr + scIdStr);
    }

    private static int getUnits(int num) {
        return num > 9 ? num % 10 : num;
    }

    public static Long decode(Long sourceMemberId) {
        return ScIdConverter.validate(sourceMemberId) ? ScIdConverter.innerDecode(sourceMemberId + "") : -1L;
    }

    private static Long innerDecode(String memberId) {
        int length = Integer.valueOf(memberId.substring(0, 1));
        int replaceLength = 10 - length;
        return Long.valueOf(memberId.substring(replaceLength, 10));
    }

    public static boolean validate(Long sourceMemberId) {
        String memberId = sourceMemberId + "";
        if (StringUtils.isEmpty((String)memberId) || memberId.length() != 10) {
            return false;
        }
        Long realscId = ScIdConverter.innerDecode(memberId);
        return sourceMemberId.equals(ScIdConverter.encode(realscId));
    }

    public static Long decodeOrGetSelf(Long sourceMemberId) {
        if (sourceMemberId == null) {
            return null;
        }
        Long decode = ScIdConverter.decode(sourceMemberId);
        if (NumberUtil.isNullOrLteZero(decode)) {
            return sourceMemberId;
        }
        return decode;
    }

    public static void main(String[] args) {
        for (long l = 0L; l < 184L; ++l) {
            long encode = ScIdConverter.encode(l);
            System.out.println(encode);
            long decode = ScIdConverter.decode(encode);
            if (l == decode) continue;
            System.out.println("encode:" + encode + " decode:" + decode);
        }
    }
}

