package cn.com.duiba.kjy.api.dto.animation;

import lombok.Data;

import java.io.Serializable;

/**
 * @author lizhi
 * @date 2019/8/23 11:42 AM
 */
@Data
public class AnimationMaterialDto implements Serializable {

    private static final long serialVersionUID = 7840287760145178545L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 素材名称
     */
    private String materialName;

    /**
     * 素材链接
     */
    private String materialUrl;

    /**
     * 素材大小
     */
    private Integer materialSize;

    /**
     * 分类主键
     */
    private Long categoryId;

    /**
     * 素材类型（图片、音乐等），由前端定义值，后端只存储
     */
    private Integer materialType;

    /**
     * 权限范围（用户、系统等），由前端定义值，后端只存储
     */
    private Integer scope;

    /**
     * 是否删除，1=已删除，0=未删除
     */
    private Integer deleted;
}
