package cn.com.duiba.kjy.api.enums.dailyPosters;

import java.util.HashMap;
import java.util.Map;

/**
 * @author linjianhui
 * @description 早晚安打卡记录
 * @date 2020/11/13 14:08
 */
public enum DailyPosterClockTypeEnum {
    /**
     * 1：早安 2:晚安
     */
    GOOD_MORNING(1, "早安打卡"),
    GOOD_NIGHT(2, "晚安打卡"),
    ;

    private Integer code;

    private String desc;

    DailyPosterClockTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private static final Map<Integer, DailyPosterClockTypeEnum> ENUM_MAP = new HashMap<>();

    static{
        for(DailyPosterClockTypeEnum recordTypeEnum : values()){
            ENUM_MAP.put(recordTypeEnum.getCode(), recordTypeEnum);
        }
    }

    public static DailyPosterClockTypeEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
