package cn.com.duiba.kjy.api.params.classify;

import cn.com.duiba.kjy.api.params.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.List;

/**
 * 复合搜索条件集合,特别耦合,希望以后别再里面加字段了 by 周舟 2020-4-2 11:02:17
 *
 * Created by dugq on 2019-07-08.
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class ClassifyContentSearchParam extends PageQuery implements Serializable {
    private static final long serialVersionUID = -677369471991580033L;
    // 分类id
    private Long classifyId;
    // 公司id
    private Long companyId;
    // 内容id集合
    private List<Long> contentIds;
    private Boolean open;
    //是否排除公有的文章
    private Boolean includePublic = true;
    private Boolean comeFromManager;
    // 内容id
    private Long contentId;
    private String title;

    /**
     * 客集集版本
     */
    private Integer contentVersion;
}
