package cn.com.duiba.kjy.api.remoteservice.home;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.home.MomentsMaterialDto;

import java.util.List;

/**
 * @author wangbinbin
 * @create 2020-03-20 13:44
 * @descript 首页发圈素材remoteService
 */
@AdvancedFeignClient
public interface RemoteMomentsMaterialService {

    /**
     * 根据内容版本类型查询
     * @param contentVersion
     * @return
     */
    List<MomentsMaterialDto> listByContentVersion(Integer contentVersion);

    /**
     * 保存
     * @param momentsMaterialDto
     * @return
     */
    boolean save(MomentsMaterialDto momentsMaterialDto);

    /**
     * 移至
     * @param id 被移动的id
     * @param moveNum 移动到的序位
     * @return
     */
    boolean move(Long id, Integer moveNum);

    /**
     * 下架(物理删除)
     * @param id
     * @return
     */
    boolean delete(Long id);

}
