package cn.com.duiba.kjy.api.dto.survey;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 问券问题表
 * @author kjj mybatis generator 
 * 2020-11-24
 */
@Data
public class SurveyQuestionDto implements Serializable {
    private static final long serialVersionUID = 16062078607429523L;

    /**
     * id
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

    /**
     * 问券Id
     */
    private Long surveyId;

    /**
     * 编码
     */
    private String code;

    /**
     * 题目类型
     * @see cn.com.duiba.kjy.api.enums.survey.SurveyQuestionTypeEnum
     */
    private String type;

    /**
     * 题目
     */
    private String title;

    /**
     * 备注/描述
     */
    private String description;

    /**
     * 是否必填，0-非必填，1必填
     * @see cn.com.duiba.kjy.api.enums.BooleanEnum
     */
    private Integer required;

    /**
     * 跳转
     */
    private String jump;

    /**
     * 展示其他隐藏的题目
     */
    private String display;

    /**
     * 校验信息
     */
    private String validate;

    /**
     * 得分制类型
     */
    private String gradeType;
}