package cn.com.duiba.kjy.api.dto.corp;

import lombok.Data;

import java.io.Serializable;

/**
 * 企业授权页面信息
 * @author zhanghuifeng
 * @date 2021/8/25 13:46
 */
@Data
public class CorpPageDto implements Serializable {
    private static final long serialVersionUID = -7572502052713065292L;

    /**
     * 权限ID
     */
    private Long authId;

    /**
     * 是否被隐藏,未隐藏：0，已隐藏：1
     * @see cn.com.duiba.kjy.api.enums.corp.PageVisibleEnum
     */
    private Integer hideState;

    /**
     * 主键ID
     */
    private Long id;

    /**
     * 是否被删除,未删除：0，已删除：1
     * @see cn.com.duiba.kjy.api.enums.DeletedEnum
     */
    private Integer logicDeleted;

    /**
     * 页面名称
     */
    private String pageName;

    /**
     * 页面url
     */
    private String pageUrl;
}
