package cn.com.duiba.kjy.api.enums.sellerImport;


/**
 * @author xiaotian
 * 爬虫文章类型，外加默认图片
 */
public enum ImportSourceTypeEnum {
    /**
     * 百度文章
     */
    BAIDU(1,"https://yun.duiba.com.cn/kjy/image/20200604/14414c72.png"),

    /**
     * 快小编
     */
    KXB(2,"https://yun.duiba.com.cn/kjy/image/20200604/14414c72.png"),

    /**
     * 人民日报
     */
    PEOPLE(3,"https://yun.duiba.com.cn/kjy/image/20200604/14414c72.png"),

    /**
     * 新浪财经
     */
    SINA_FINANCE(4,"https://yun.duiba.com.cn/kjy/image/20200604/14414c72.png"),

    /**
     * 抖音视频
     */
    TIKTOK(5,"https://yun.duiba.com.cn/kjy/image/20200604/14414c72.png"),

    /**
     * 今日头条
     */
    TODAY_LINE(6,"https://yun.duiba.com.cn/kjy/image/20200604/14414c72.png"),

    /**
     * 人人都是产品经理
     */
    WO_SHI_PM(7,"https://yun.duiba.com.cn/kjy/image/20200604/14414c72.png"),

    /**
     * 微信公众号
     */
    WX_PLAT(8,"https://yun.duiba.com.cn/kjy/image/20200604/14414c72.png"),

    /**
     * 全网链接
     */
    NETWORK_LINK(9,"https://yun.duiba.com.cn/kjy/image/20200604/14414c72.png"),
    /**
     * 泛华保网
     */
    BAOWANG(10,"https://yun.duiba.com.cn/kjy/image/20200604/14414c72.png"),

    /**
     * 知乎
     */
    ZHIHU(11,"https://yun.duiba.com.cn/kjy/image/20200604/14414c72.png"),
    /**
     * 一点资讯
     */
    YIDIANZIXUN(12,"https://yun.duiba.com.cn/kjy/image/20200604/14414c72.png"),
    /**
     * 腾讯新闻
     */
    TENCENT(13,"https://yun.duiba.com.cn/kjy/image/20200604/14414c72.png"),
    /**
     * 网易新闻
     */
    NTES(14,"https://yun.duiba.com.cn/kjy/image/20200604/14414c72.png"),
    /**
     * 看点快报
     */
    KUAIBAO(15,"https://yun.duiba.com.cn/kjy/image/20200604/14414c72.png"),
    /**
     * 澎湃新闻
     */
    THEPAPER(16,"https://yun.duiba.com.cn/kjy/image/20200604/14414c72.png"),
    /**
     * 凤凰新闻
     */
    IFENG(17,"https://yun.duiba.com.cn/kjy/image/20200604/14414c72.png"),
    /**
     * 趣头条
     */
    QUTOUTIAO(18,"https://yun.duiba.com.cn/kjy/image/20200604/14414c72.png"),
    /**
     * 惠头条
     */
    CASHTOUTIAO(19,"https://yun.duiba.com.cn/kjy/image/20200604/14414c72.png"),
    ;

    ImportSourceTypeEnum(Integer code, String image) {
        this.code = code;
        this.image = image;
    }

    public static String getImageByCode(Integer code){
        for (ImportSourceTypeEnum importSourceTypeEnum : ImportSourceTypeEnum.values()){
            if(importSourceTypeEnum.getCode().equals(code)){
                return importSourceTypeEnum.getImage();
            }
        }
        return "https://yun.duiba.com.cn/kjy/image/20200604/14414c72.png";
    }

    private Integer code;
    private String image;

    public Integer getCode() {
        return code;
    }

    public String getImage() {
        return image;
    }
}
