package cn.com.duiba.kjy.api.remoteservice.sms.recipient;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.sms.SmsRecipientDto;
import cn.com.duiba.kjy.api.params.sms.SmsRecipientUpdateParam;

import java.util.List;

/**
 * @author gxy
 * @date 2021/5/27 3:16 下午
 */
@AdvancedFeignClient
public interface RemoteRecipientService {
    /**
     * 批量插入
     * @param list 数据
     * @return 插入条数
     */
    Integer batchInsert(List<SmsRecipientDto> list);

    /**
     * 批量删除
     * @param list 数据
     * @return 删除结果
     */
    Integer batchDel(List<Long> list);

    /**
     * 瀑布流查询
     * @param smsPushId 推送任务id
     * @param pageSize 分页大小
     * @param lastId 上一页最大id
     * @return 查询结果
     */
    List<SmsRecipientDto> batchSelectBySmsPushId(Long smsPushId,Integer pageSize,Long lastId);

    /**
     * 根据id批量填充bizId
     * @param bizId 回执id
     * @param ids 主键
     */
    void updateByIds(String bizId,List<Long> ids);

    /**
     * 根据手机号和bizId更新
     * @param bizId 回执id
     * @param phone 手机号
     * @param success 是否接收成功
     */
    void updateByBizId(String bizId,String phone,Boolean success);

    /**
     * 根据bizId批量更新
     * @param list bizIds
     * @return 修改结果
     */
    Integer updateByBizIds(List<SmsRecipientUpdateParam> list);
}
