package cn.com.duiba.kjy.api.enums.order;

/**
 * 支付来源枚举
 * @author zhanghuifeng
 * date 2019/9/10-5:05 下午
 */
public enum PaySourceEnum {

    DISCOUNTS_QR(1, "优惠码推送进入付费"),
    OPEN_VIP_MENU(2, "点击菜单中开通会员付费"),
    ARTICLE_MIDDLE_LOCATION(3, "文章中间资源位"),
    WHO_HAS_SEEN_ME(4, "谁看过我转化付费"),
    SELLER_RENEW(5, "会员续费"),
    LIVE_SELLER_RENEW(201, "直播会员续费"),
    ;
    private Integer code;

    private String desc;

    PaySourceEnum(Integer code, String desc){
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
