package cn.com.duiba.kjy.api.enums.seller;

/**
 * 代理人动态类型枚举
 * @author zhanghuifeng
 * date 2020/3/21-2:18 下午
 */
public enum SellerDynamicTypeEnum {

    VISIT(1, "访问"),
    FORWARD_MATERIAL(2, "转发素材"),
    FORWARD_CARD(3, "转发名片"),
    USE_MARKETING_TOOL(4, "使用营销工具"),
    GAIN_SALE_CLUE(5, "获得销售线索"),
    NEW_FOLLOW_CUSTOMER(6, "新增跟进客户"),
    ;
    private Integer code;

    private String desc;

    SellerDynamicTypeEnum(Integer code, String desc){
        this.code = code;
        this.desc = desc;
    }

    /**
     * x
     * @param code
     * @return
     */
    public static SellerDynamicTypeEnum getByCode(Integer code) {
        for (SellerDynamicTypeEnum enumVal : SellerDynamicTypeEnum.values()) {
            if (enumVal.getCode().equals(code)) {
                return enumVal;
            }
        }
        return null;
    }

    public static String getDescByCode(Integer code) {
        for (SellerDynamicTypeEnum enumVal : SellerDynamicTypeEnum.values()) {
            if (enumVal.getCode().equals(code)) {
                return enumVal.getDesc();
            }
        }
        return "";
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
