package cn.com.duiba.kjy.api.enums.sellercard;

import java.util.Objects;

/**
 * @author 吴文哲
 * @date 2020-03-17 14:36
 **/
public enum AppraiseStateEnum {

    DEFAULT(0,"代理人拒绝展示"),
    SELLER_AGREE_SHOW(1,"代理人同意展示"),
    SELLER_DISAGREE_SHOW(2,"代理人删除状态"),
    ;

    /**
     * 评价状态
     */
    private Integer state;

    /**
     * 描述
     */
    private String desc;

    AppraiseStateEnum(Integer state,String desc){
        this.state = state;
        this.desc = desc;
    }

    public Integer getState() {
        return state;
    }

    public String getDesc() {
        return desc;
    }

    public static AppraiseStateEnum getByState(Integer state){
        for (AppraiseStateEnum enumVal : AppraiseStateEnum.values()) {
            if (Objects.equals(enumVal.getState(), state)) {
                return enumVal;
            }
        }
        return null;
    }
}
