package cn.com.duiba.kjy.api.remoteservice.corp;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.corp.CorpCompanyDto;
import cn.com.duiba.kjy.api.params.Page;
import cn.com.duiba.kjy.api.params.corp.ChangeCompanyStateParam;
import cn.com.duiba.kjy.api.params.corp.QueryCompanyParam;
import cn.com.duiba.kjy.api.params.corp.SaveCompanyInfoParam;

import java.util.List;

/**
 * @author: HanYaLun
 * @description: 企业后台管理-公司管理
 * @create: 2021-08-24 3:03 下午
 */
@AdvancedFeignClient
public interface RemoteCorpCompanyService {

    /**
     * 根据公司id查询公司信息
     *
     * @param id 公司id
     * @return 公司信息
     */
    CorpCompanyDto findById(Long id);

    /**
     * 通过企业名称模糊查询企业信息
     *
     * @param companyName 企业名称
     * @return 公司信息
     */
    List<CorpCompanyDto> search(String companyName);

    /**
     * 根据条件分页查询公司信息
     *
     * @param param 搜索参数
     * @return 公司信息
     */
    Page<CorpCompanyDto> selectCompanyList(QueryCompanyParam param);

    /**
     * 保存或者更新企业信息
     *
     * @param param 企业信息参数
     * @return 操作成功的条数
     */
    Integer saveOrUpdate(SaveCompanyInfoParam param);

    /**
     * 更改企业状态
     *
     * @param param 更新企业状态信息
     * @return 更新成功的条数
     */
    Integer changeCompanyState(ChangeCompanyStateParam param);

    /**
     * 通过id集合查询企业信息
     * @param ids   id集合
     * @return  企业信息集合
     */
    List<CorpCompanyDto> listByIds(List<Long> ids);
}
