package cn.com.duiba.kjy.api.dto.sms;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 短信模版表
 * @author kjj mybatis generator 
 * 2021-05-24
 */
@Data
public class SmsTemplateDto implements Serializable {
    private static final long serialVersionUID = 16218226405622873L;

    /**
     *
     *主键
     * not null default = null
     */
    private Long id;

    /**
     *
     *短信模版CODE,查询模版申请状态时需要传给阿里
     * max length = 20
     */
    private String templateCode;

    /**
     *
     *短信类型 0:验证码 1:短信通知 2:推广短信 3:国际/港澳台消息
     * not null default = null
     */
    private Byte templateType;

    /**
     *
     *模版名称 1～30字符
     * max length = 30
     * not null default = null
     */
    private String templateName;

    /**
     *
     *模版内容 1～500字符
     * max length = 500
     * not null default = null
     */
    private String templateContent;

    /**
     *
     *模版审核状态 0:审核中 1:审核通过 2:拒绝
     */
    private Byte templateReviewStatus;

    /**
     *
     *审核状态描述
     * max length = 500
     */
    private String templateReviewDesc;

    /**
     *
     *模版申请说明 1～100 字符
     * max length = 100
     * not null default = null
     */
    private String templateRemark;

    /**
     *
     *创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     *
     *更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;
}