package cn.com.duiba.kjy.api.enums.survey;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.stream.Stream;

/**
 * @author liuchao1
 * @version 1.0
 * @date 2020/11/24 17:10
 */
@AllArgsConstructor
@Getter
public enum SurveyStatusEnum {

    CLOSE(0, "关闭"),

    OPEN(1, "开启"),

    ;

    private Integer code;
    private String desc;

    public static SurveyStatusEnum getByCode(Integer contentType){
        return Stream.of(SurveyStatusEnum.values()).filter(shareEntranceContentTypeEnum -> shareEntranceContentTypeEnum.getCode().equals(contentType)).findFirst().orElse(null);
    }
}
