package cn.com.duiba.kjy.api.params.interaction;

import cn.com.duiba.kjy.api.params.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author lizhi
 * @date 2019/9/23 1:55 PM
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class ContentInteractionTemplateSearchParams extends PageQuery {

    private static final long serialVersionUID = -6154134061053909883L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 标题
     */
    private String title;

    /**
     * 模板类型, 0-投票，1-答题，2-表格
     * @see cn.com.duiba.kjy.api.enums.interaction.InteractionTemplateTypeEnum
     */
    private Integer templateType;

    /**
     * 选择类型，0-单选，1-多选
     * @see cn.com.duiba.kjy.api.enums.interaction.InteractionSelectionTypeEnum
     */
    private Integer selectionType;

    /**
     * 一级标签，tb_kjy_tag.id
     */
    private Long tag1Id;

    /**
     * 二级标签，tb_kjy_tag.id
     */
    private Long tag2Id;

    /**
     * 来源：1-题库，2-销售员模板
     * @see cn.com.duiba.kjy.api.enums.interaction.InteractionTemplateSourceEnum
     */
    private Integer templateSource;

    /**
     * 状态：0-未启用，1-启用
     * @see cn.com.duiba.kjy.api.enums.interaction.InteractionTemplateStateEnum
     */
    private Integer state;
}
