package cn.com.duiba.kjy.api.remoteservice.corp;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.corp.CorpStaffDto;
import cn.com.duiba.kjy.api.dto.corp.StaffInfoDto;
import cn.com.duiba.kjy.api.params.Page;
import cn.com.duiba.kjy.api.params.corp.ChangeStaffStateParam;
import cn.com.duiba.kjy.api.params.corp.QueryStaffParam;
import cn.com.duiba.kjy.api.params.corp.SaveStaffInfoParam;

import java.util.List;

/**
 * 企业后台管理-公司管理-员工管理
 * @author zhanghuifeng
 * @date 2021/8/24 17:30
 */
@AdvancedFeignClient
public interface RemoteCorpStaffService {

    /**
     * 查询员工信息
     *
     * @param param 员工筛选信息
     * @return 员工信息列表
     */
    Page<StaffInfoDto> selectStaffInfo(QueryStaffParam param);

    /**
     * 新增或更新员工信息
     *
     * @param param 员工信息
     * @return 是否新增或更新成功
     */
    Integer saveOrUpdateStaffInfo(SaveStaffInfoParam param);

    /**
     * 根据手机号查询信息
     * @param phone 手机号
     * @return 企业用户信息
     */
    List<CorpStaffDto> listByPhone(String phone);

    /**
     * 更新员工状态
     *
     * @param param 员工信息
     * @return 是否更新成功
     */
    Integer changeStaffState(ChangeStaffStateParam param);

    /**
     * 删除员工
     *
     * @param id 员工信息主键
     * @return 是否删除成功
     */
    Integer deleteStaffById(Long id);

    /**
     * 在同一公司下,是否有重复的手机号码
     *
     * @param companyId 企业id
     * @param phone     手机号
     * @return 查到的记录
     */
    CorpStaffDto findByCompanyIdAndPhone(Long companyId, String phone);

    /**
     * 根据主键id查询员工信息
     * @param id 主键id
     * @return 员工信息
     */
    CorpStaffDto findById(Long id);
}
