package cn.com.duiba.kjy.api.remoteservice.guess;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.guess.GuessQuesContentClueDto;

import java.util.List;

/**
 * 猜你所想文章线索
 * @author 吴文哲
 * @date 2021/4/30 2:02 下午
 **/
@AdvancedFeignClient
public interface RemoteGuessQuesContentClueService {

    /**
     * 保存线索
     * @param guessQuesContentClueDto 猜你所想文章线索详情
     * @return id 主键
     */
    Long saveClue(GuessQuesContentClueDto guessQuesContentClueDto);

    /**
     * 根据scid + userId + quesId 查询猜你所想线索提交记录
     * @param scid 代理人素材id
     * @param userId 访客用户id
     * @param quesId 问题id
     * @return 猜你所想线索详情
     */
    GuessQuesContentClueDto findByScidUserIdAndQuesId(Long scid, Long userId, Long quesId);

    /**
     * 根据线索id查询
     * @param clueId 线索id
     * @return 猜你所想线索详情
     */
    GuessQuesContentClueDto findById(Long clueId);

    /**
     * 根据线索id查询
     * @param clueIds 线索id
     * @return 猜你所想线索详情
     */
    List<GuessQuesContentClueDto> findByIds(List<Long> clueIds);

}
