package cn.com.duiba.kjy.api.enums.feedback;

import cn.com.duiba.kjy.api.util.NumberUtil;
import com.google.common.collect.ImmutableMap;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 反馈类型
 *
 * @author xuzhigang
 * @date 2021/7/13 10:49 上午
 **/
@Getter
@AllArgsConstructor
public enum FeedbackTypeEnum {
    FUNCTION_ERROR(1, "功能异常"),

    EXPERIENCE_PROBLEM(2, "体验问题"),

    NEW_FEATURE_SUGGEST(3, "新功能建议"),

    OTHER(4, "其他"),
    ;

    private final Integer type;

    private final String desc;

    private static final ImmutableMap<Integer, FeedbackTypeEnum> map = ImmutableMap.<Integer, FeedbackTypeEnum>builder()
            .put(FUNCTION_ERROR.getType(), FUNCTION_ERROR)
            .put(EXPERIENCE_PROBLEM.getType(), EXPERIENCE_PROBLEM)
            .put(NEW_FEATURE_SUGGEST.getType(), NEW_FEATURE_SUGGEST)
            .put(OTHER.getType(), OTHER).build();

    /**
     * 根据类型获取枚举
     */
    public static FeedbackTypeEnum getEnumByType(Integer type) {
        if (NumberUtil.isNullOrLteZero(type)) {
            return null;
        }
        return map.get(type);
    }
}
