package cn.com.duiba.kjy.api.dto;

import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;

/**
 * @auther: linjianhui
 * @date: 2019-03-16 11:39
 * @description: 用户活动参与表单信息
 */
@Data
@ToString
public class SellerActivityVisitDto implements Serializable {

    private static final long serialVersionUID = -7287132955690302256L;

    /**
     * 主键id
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 编辑时间
     */
    private Date gmtModified;

    /**
     * 销售用户id
     */
    private Long userId;

    /**
     * 销售id
     */
    private Long sellerId;

    /**
     * 客集集活动id
     */
    private Long activityId;

    /**
     * 是否中大奖 0否  1是
     */
    private Integer activityPrizeMark;

    /**
     * 活动奖品名称
     */
    private String activityPrizeName;

    /**
     * 销售和客户是否绑定  1=绑定、0=未绑定
     */
    private Integer sellerVisitBind;

    /**
     * 参与用户id
     */
    private Long visitId;

    /**
     * 参与用户名称
     */
    private String visitName;

    /**
     * 参与用户电话
     */
    private String visitPhone;

    /**
     * 参与用户地址省
     */
    private String visitProvince;

    /**
     * 参与用户地址市
     */
    private String visitCity;

    /**
     * 参与用户所在区/县
     */
    private String visitDistrict;

    /**
     * 参与用户详细地址
     */
    private String visitAddrDetail;

    /**
     * 参与用户拓展信息
     */
    private String visitExtra;

    /**
     * 处理标志
     */
    private Integer readMark;

    /**
     * 处理标志
     */
    private String activityName;

    /**
     * 活动奖品图片
     */
    private String activityPrizeImg;

    /**
     * 表单是否提交完成
     */
    private Integer completed;

    /**
     * tb_users_visit.id
     */
    private Long tableVisitId;

    /**
     * 0-未接受 1-愿意接受
     * @see cn.com.duiba.kjy.api.enums.BooleanEnum
     */
    private Integer acceptState;
}
