package cn.com.duiba.kjy.api.dto.attend;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 签到领红包任务表
 *
 * @author kjj mybatis generator
 * 2021-08-30
 */
@Data
public class AttendRedTaskDto implements Serializable {
    private static final long serialVersionUID = 16302915235833590L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 销售员id
     */
    private Long sellerId;

    /**
     * 任务状态 1=进行中 2=完成 3=失败 4=封禁
     * @see cn.com.duiba.kjy.api.enums.attend.AttendRedTaskStatusEnum
     */
    private Integer taskStatus;

    /**
     * 执行次数
     */
    private Integer processTimes;

    /**
     * 上次执行日期
     */
    private Date lastProcessDate;

    /**
     * 上一轮次
     */
    private Integer lastProcessRound;
}