package cn.com.duiba.kjy.api.params.honorary;

import cn.com.duiba.kjy.api.params.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 荣誉相册访问记录查询参数
 * @author 吴文哲
 * @date 2020-02-19 17:25
 **/
@EqualsAndHashCode(callSuper = true)
@Data
public class VisitorHonoraryAlbumRecordParam extends PageQuery {

    private static final long serialVersionUID = 8066896407939566835L;

    /**
     * 配置id
     */
    private Long confId;

    /**
     * 代理人id
     */
    private Long sellerId;

    /**
     * 开始创建时间（包含）
     */
    private Date startCreateTime;

    /**
     * 结束创建时间（不包含）
     */
    private Date endCreateTime;

    /**
     * 是否过滤掉自己
     * 默认不过滤掉
     */
    private boolean ignoreSelf = false;
}
