package cn.com.duiba.kjy.api.enums.greeting;

import org.apache.commons.lang3.StringUtils;

/**
 * @Author: zhouzhou
 * @Description: 海报编辑场景
 * @Date: Create in 上午 2020年2月4日 11:09:10
 */
public enum PosterEditSceneEnum {

    PREVIEW("1", "预览"),
    EDIT("2", "编辑"),
    SAVED("3", "保存预览"),

    ;


    private String code;
    private String value;

    PosterEditSceneEnum(String code, String value) {
        this.code = code;
        this.value = value;
    }

    public String getCode() {
        return code;
    }

    public String getValue() {
        return value;
    }

    /**
     * 根据编码查询枚举。
     *
     * @param code 编码。
     * @return 枚举。
     */
    public static PosterEditSceneEnum getByCode(String code) {
        for (PosterEditSceneEnum value : PosterEditSceneEnum.values()) {
            if (StringUtils.equals(code, value.getCode())) {
                return value;
            }
        }
        return null;
    }

    /**
     * 枚举是否包含此code
     *
     * @param code 枚举code
     * @return 结果
     */
    public static Boolean contains(String code) {
        for (PosterEditSceneEnum value : PosterEditSceneEnum.values()) {
            if (StringUtils.equals(code, value.getCode())) {
                return true;
            }
        }
        return false;
    }
}
