package cn.com.duiba.kjy.api.remoteservice.autoreply;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.autoreply.AutoReplyBaseInfoDto;
import cn.com.duiba.kjy.api.dto.autoreply.PushMsgDto;
import cn.com.duiba.kjy.api.dto.autoreply.ReceiveTextDto;
import cn.com.duiba.kjy.api.dto.autoreply.AutoReplyAllInfoDto;
import cn.com.duiba.kjy.api.dto.autoreply.AutoReplyConfDto;
import cn.com.duiba.kjy.api.enums.autoreply.AutoReplyStateEnum;
import cn.com.duiba.kjy.api.params.Page;
import cn.com.duiba.kjy.api.params.autoreply.AutoReplyBaseInfoParams;
import cn.com.duiba.user.service.api.dto.oa.OfficialAccountDto;

import java.util.List;

/**
 * @auther: linjianhui
 * @date: 2020-03-02 11:50
 * @description: 自动回复相关
 */
@AdvancedFeignClient
public interface RemoteAutoReplyService {

    /**
     * 启用/未启用
     *
     * @param id
     * @param state
     * @return
     */
    boolean changeState(Long id, AutoReplyStateEnum state);

    /**
     * 通过id删除
     *
     * @param id
     * @return
     */
    boolean deleteById(Long id);

    /**
     * 根据代理人回复，自动回复
     *
     * @param officialAccountDto 回复的账号
     * @param receiveTextDto     回复的信息
     * @return
     */
    boolean autoReply(OfficialAccountDto officialAccountDto, ReceiveTextDto receiveTextDto);

    /**
     * 根据自动回复基本配置id查询对应的配置信息
     *
     * @param id 自动回复基本配置id
     * @return 对应的配置信息
     */
    AutoReplyAllInfoDto findAutoReplyById(Long id);

    /**
     * 根据筛选条件查询对应的自动回复列表信息
     *
     * @param params 筛选条件
     * @return 对应的自动回复信息
     */
    Page<AutoReplyBaseInfoDto> selectListByParams(AutoReplyBaseInfoParams params);

    /**
     * 新增自动回复,新增基本配置和回复内容
     *
     * @param dto 基本配置和回复内容
     * @return 基本配置的主键
     */
    Long saveAutoReplyDto(AutoReplyAllInfoDto dto);

    /**
     * 更新自动回复,更新基本配置和回复内容
     *
     * @param dto 基本配置和回复内容
     * @return 更新的条数
     */
    int updateAutoReplyDto(AutoReplyAllInfoDto dto);

    /**
     * 根据回复内容查询对应的配置信息
     * 关键字非唯一,不同的公众号对应不同的内容
     *
     * @param replyContent 回复内容
     * @return 查询到的对应的配置信息
     */
    List<AutoReplyConfDto> findAutoReplyConfDtoByContent(String replyContent);

    /**
     * 给指定代理人进行推送
     * @param pushMsgDto 推送消息
     * @return 是否推送成功
     */
    boolean pushMsgToOa(PushMsgDto pushMsgDto);
}
