/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.api.enums.crm;

import cn.com.duiba.kjy.api.enums.crm.CrmCustumerIntentionEnum;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.springframework.util.CollectionUtils;

public enum CrmCommonExtColumnEnum {
    BIZ_CITY(1, "bizCity"),
    TODAY_SCHEDULED_CUSTOMER(2, "todayScheduledCustomer"),
    INTENTION_TOPIC(3, "intentionTopic"),
    INTENTION_SCHEDULE(4, "intentionSchedule"),
    BUDGET(5, "budget"),
    OBJECTION(6, "objection"),
    FOLLOW_PLAN(7, "followPlan");

    private final Integer code;
    private final String paramName;
    private static final Integer MAX_LENGTH;
    private static final Map<Integer, CrmCommonExtColumnEnum> CODE_MAP;
    private static final Map<String, CrmCommonExtColumnEnum> PARAM_NAME_MAP;

    private CrmCommonExtColumnEnum(Integer code, String paramName) {
        this.code = code;
        this.paramName = paramName;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getParamName() {
        return this.paramName;
    }

    public static CrmCommonExtColumnEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return CODE_MAP.get(code);
    }

    public static CrmCommonExtColumnEnum getByParamName(String paramName) {
        if (paramName == null) {
            return null;
        }
        return PARAM_NAME_MAP.get(paramName);
    }

    public static Map<Integer, String> transBizExtsForward(Map<String, String> bizExts) {
        if (CollectionUtils.isEmpty(bizExts)) {
            return null;
        }
        HashMap bizExtsTrans = Maps.newHashMap();
        for (String paramName : bizExts.keySet()) {
            if (!Objects.nonNull((Object)CrmCommonExtColumnEnum.getByParamName(paramName))) continue;
            bizExtsTrans.put(CrmCommonExtColumnEnum.getByParamName(paramName).getCode(), Optional.ofNullable(bizExts.get(paramName)).orElse(""));
        }
        CrmCommonExtColumnEnum.checkLength(bizExtsTrans);
        return bizExtsTrans;
    }

    public static Map<String, String> transBizExtsReverse(Map<Integer, String> bizExts) {
        if (CollectionUtils.isEmpty(bizExts)) {
            return null;
        }
        HashMap bizExtsTrans = Maps.newHashMap();
        for (Integer code : bizExts.keySet()) {
            if (!Objects.nonNull((Object)CrmCommonExtColumnEnum.getByCode(code))) continue;
            bizExtsTrans.put(CrmCommonExtColumnEnum.getByCode(code).getParamName(), bizExts.get(code));
        }
        return bizExtsTrans;
    }

    private static void checkLength(Map<Integer, String> bizExts) {
        if (CollectionUtils.isEmpty(bizExts)) {
            return;
        }
        ArrayList removeKeys = Lists.newArrayList();
        for (Map.Entry<Integer, String> entry : bizExts.entrySet()) {
            if (entry.getValue().length() >= MAX_LENGTH) {
                removeKeys.add(entry.getKey());
            }
            if (!Objects.equals(INTENTION_TOPIC.getCode(), entry.getKey()) || CrmCustumerIntentionEnum.containsCode(entry.getValue()).booleanValue()) continue;
            removeKeys.add(entry.getKey());
        }
        if (!CollectionUtils.isEmpty((Collection)removeKeys)) {
            for (Integer code : removeKeys) {
                bizExts.remove(code);
            }
        }
    }

    static {
        MAX_LENGTH = 200;
        CODE_MAP = new HashMap<Integer, CrmCommonExtColumnEnum>();
        PARAM_NAME_MAP = new HashMap<String, CrmCommonExtColumnEnum>();
        for (CrmCommonExtColumnEnum item : CrmCommonExtColumnEnum.values()) {
            CODE_MAP.put(item.getCode(), item);
            PARAM_NAME_MAP.put(item.getParamName(), item);
        }
    }
}

