package cn.com.duiba.kjy.api.enums.orderRefund;

import java.util.HashMap;
import java.util.Map;

/**
 * @author xiaotian
 * @date 2020/4/22 11:09 AM
 */
public enum OrderPayRefundEnum {

    INI(0, "待退款"),
    REFUNDING(1,"退款中"),
    REFUND_SUCCESS(2,"退款成功"),
    REFUND_FAIL(3,"退款失败")
    ;

    private Integer code;
    private String desc;

    OrderPayRefundEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getDesc() {
        return desc;
    }

    public Integer getCode() {
        return code;
    }

    private static final Map<Integer, OrderPayRefundEnum> ENUM_MAP = new HashMap<>();

    static{
        for(OrderPayRefundEnum tmp : values()){
            ENUM_MAP.put(tmp.getCode(), tmp);
        }
    }

    public static OrderPayRefundEnum getByCode(Integer code) {
        return ENUM_MAP.get(code);
    }
}
