package cn.com.duiba.kjy.api.remoteservice.appvideo;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.appvideo.AppVideoInstallPackageDto;

import java.util.List;
import java.util.Map;

/**
 * @author likui
 * @date 2021/10/11 4:54 下午
 * 安装包上传配置rpc
 **/
@AdvancedFeignClient
public interface RemoteAppVideoInstallPackageApiService {
    /**
     * 查询单个安装包配置信息
     * @param id 主键值
     * @return 安装包配置信息
     */
    AppVideoInstallPackageDto selectOne(Long id);

    /**
     * 更新安装包配置信息
     * @param installPackageDto 更新参数
     * @return 更新结果
     */
    int update(AppVideoInstallPackageDto installPackageDto);

    /**
     * 新增安装包配置信息
     * @param installPackageDto 安装包新增参数
     * @return 新增结果
     */
    int insert(AppVideoInstallPackageDto installPackageDto);

    /**
     * 根据分页参数和版本号查询安装包配置信息
     * @param version 版本号
     * @param offset 偏移量
     * @param pageSize 每页大小
     * @return 安装包配置信息列表
     */
    List<AppVideoInstallPackageDto> selectList(String version, Integer offset, Integer pageSize);

    /**
     * 根据ID查询安装包地址
     * @param ids 主键集合
     * @return ID和安装包的映射
     */
    Map<Long,String> getInstallPackageUrl(List<Long> ids);

    /**
     * 查询记录条数
     * @return 记录条数
     */
    Integer selectCount();
}
