package cn.com.duiba.kjy.api.remoteservice.user;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.UserCollectIdAndItemIdDto;
import cn.com.duiba.kjy.api.dto.user.UserCollectItemDto;
import cn.com.duiba.kjy.api.params.user.UserCollectionQryParams;

import java.util.List;

/**
 * 用户收藏信息服务
 * @author zhanghuifeng
 * date 2019-04-15-15:10
 */
@AdvancedFeignClient
public interface RemoteUserCollectItemService {

    /**
     * 添加收藏
     * @param dto
     * @return
     */
    Boolean save(UserCollectItemDto dto);

    /**
     * 删除收藏
     * @param userId
     * @param itemId
     * @param itemType @see UserCollectItemTypeEnum
     * @return
     */
    Boolean delete(Long userId, Long itemId, int itemType);

    /**
     * 根据销售员ID分页获取收藏信息
     * @param params
     * @return
     */
    List<UserCollectItemDto> listPageByUserId(UserCollectionQryParams params);

    /**
     * 查询收藏
     * @param userId
     * @param itemId
     * @param itemType @see UserCollectItemTypeEnum
     * @return
     */
    UserCollectItemDto find(Long userId, Long itemId, int itemType);

    /**
     * 分页查询收藏列表
     * @param userId 用户ID
     * @param itemType 内容类型
     * @param lastId 上一次获取的列表中最后一条收藏id
     * @param pageSize 分页大小
     * @return
     */
    List<UserCollectIdAndItemIdDto> listPageByUIdAndTypeAndId(Long userId, Integer itemType, Long lastId, Integer pageSize);

    /**
     * 根据用户id和内容类型查询收藏列表
     * @param userId 用户id
     * @param itemType 内容类型
     * @return
     */
    List<Long> queryListByUIdAndType(Long userId,Integer itemType);
    /**
     * 查询最近4天的收藏 （发圈素材收藏专用）
     * @param userId
     * @param type
     * @return
     */
    List<Long> queryRecentFourDayList(Long userId,Integer type);

    /**
     * 根据param查询列表
     * @param params
     * @return
     */
    List<UserCollectItemDto> listByParam(UserCollectionQryParams params);

}
