package cn.com.duiba.kjy.api.enums.interaction;

import java.util.HashMap;
import java.util.Map;

/**
 * @author lizhi
 * @date 2019/9/19 3:39 PM
 */
public enum InteractionEnableConfigEnum {

    DRAFT((byte)0,"不启用"),
    OPEN((byte)1,"启用"),
    ;

    private Byte code;
    private String desc;

    InteractionEnableConfigEnum(Byte code, String desc){
        this.code = code;
        this.desc = desc;
    }

    public Byte getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    private static final Map<Byte, InteractionEnableConfigEnum> ENUM_MAP = new HashMap<>();

    static{
        for(InteractionEnableConfigEnum configEnum : values()){
            ENUM_MAP.put(configEnum.getCode(), configEnum);
        }
    }

    public static InteractionEnableConfigEnum getByCode(Byte code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }
}
