package cn.com.duiba.kjy.api.remoteservice.articlePrize;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.articlePrize.ArticlePrizeOrderDto;

/**
 * 文内抽奖订单 Service
 *
 * @author xiaotian
 * 2020-12-15 17:28:43
 */
@AdvancedFeignClient
public interface RemoteArticlePrizeOrderService {
    /**
     * 新增记录
     */
    Boolean save(ArticlePrizeOrderDto dto);

    /**
     * 根据id删除
     */
    Boolean deleteById(Long id);

    /**
     * 根据id更新
     */
    Boolean updateById(ArticlePrizeOrderDto dto);

    /**
     * 根据id获取
     */
    ArticlePrizeOrderDto getById(Long id);

    /**
     * 根据articlePrizeId和visitId查询中奖记录
     *
     * @param articlePrizeId
     * @param visitId
     * @return
     */
    ArticlePrizeOrderDto findByPrizeIdAndVisitId(Long articlePrizeId, Long visitId);

}
