package cn.com.duiba.kjy.api.remoteservice.corp;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.corp.AuthInfoDto;
import cn.com.duiba.kjy.api.dto.corp.AuthStatisticsDto;
import cn.com.duiba.kjy.api.dto.corp.CorpAuthDto;
import cn.com.duiba.kjy.api.params.corp.QueryAuthInfoParam;

import java.util.List;

/**
 * @author: HanYaLun
 * @description: 企业管理-权限管理
 * @create: 2021-08-24 7:21 下午
 */
@AdvancedFeignClient
public interface RemoteCorpAuthService {

    /**
     * 通过筛选条件查询权限统计
     *
     * @param param 筛选条件
     * @return 查询的权限统计信息
     */
    List<AuthStatisticsDto> selectAuthInfo(QueryAuthInfoParam param);

    /**
     * 新增或者更新权限信息
     *
     * @param authInfoDto 权限信息
     * @return 影响的条数
     */
    Integer saveOrUpdateAuthInfo(AuthInfoDto authInfoDto);

    /**
     * 根据id删除权限
     *
     * @param id 权限id
     * @return 影响的条数
     */
    Integer deleteAuthById(Long id);

    /**
     * 根据主键id查询权限信息
     * @param id 主键id
     * @return 权限信息
     */
    CorpAuthDto findById(Long id);
}
